<?php $__env->startSection('main_content'); ?>
<!--==============================
Breadcrumb Area
==============================-->
<section class="breadcrumb__area fix" data-background="<?php echo e(asset('uploads/'.$global_setting->banner)); ?>">
    <div class="breadcrumb__bg-shape"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb__content">
                    <h3 class="title"><?php echo e($global_page_item->photo_gallery_page_title); ?></h3>
                </div>
            </div>
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb-wrap">
                    <nav class="breadcrumb">
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem"><?php echo e($global_page_item->photo_gallery_page_title); ?></span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->

<!--==============================
Project Area
==============================-->
<section class="project-area-3 pt-120 pb-120 overflow-hidden">
    <div class="container">
        <div class="row gy-30">
            <?php $__empty_1 = true; $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-lg-4">
                <div class="project-card3 style2">
                    <div class="project-thumb image-anim">
                        <a href="<?php echo e(asset('uploads/'.$photo->photo)); ?>" class="popup-image"><img src="<?php echo e(asset('uploads/'.$photo->photo)); ?>" alt="img"></a>
                    </div>
                    <?php if($photo->caption != ''): ?>
                    <div class="project-card-details">
                        <div class="project-card-content">
                            <h4 class="gallery-title"><?php echo e($photo->caption); ?></h4>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-lg-12">
                <p class="text-center text-danger"><?php echo e(__('No Photo Found')); ?></p>
            </div>
            <?php endif; ?>
        </div>

        <?php if($photos->hasPages()): ?>
        <div class="row gy-30">
            <div class="col-md-12 d-flex justify-content-center">
                <div class="pagination__wrap mt-60">
                    <ul class="list-wrap d-flex flex-wrap">
                        <?php
                            $current = $photos->currentPage();
                            $last = $photos->lastPage();
                        ?>
                        <?php if(!$photos->onFirstPage()): ?>
                            <li>
                                <a href="<?php echo e($photos->previousPageUrl()); ?>" class="page-numbers">
                                    <svg width="15" height="13" viewBox="0 0 15 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6 1L0 7M0 7L6 13M0 7H15" stroke="currentColor" stroke-width="1.5"/>
                                    </svg>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php for($page=1;$page<=$last;$page++): ?>
                            <?php if($page === $current): ?>
                                <li><span class="page-numbers current"><?php echo e(sprintf('%02d', $page)); ?></span></li>
                            <?php else: ?>
                                <li><a href="<?php echo e($photos->url($page)); ?>" class="page-numbers"><?php echo e(sprintf('%02d', $page)); ?></a></li>
                            <?php endif; ?>
                        <?php endfor; ?>
                        <?php if($photos->hasMorePages()): ?>
                            <li>
                                <a href="<?php echo e($photos->nextPageUrl()); ?>" class="page-numbers">
                                    <svg width="15" height="13" viewBox="0 0 15 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 1L15 7M15 7L9 13M15 7H0" stroke="currentColor" stroke-width="1.5"/>
                                    </svg>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>
<!--======== / Project Section ========-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/photo_gallery.blade.php ENDPATH**/ ?>