<?php $__env->startSection('main_content'); ?>
<!--==============================
Breadcrumb Area
==============================-->
<section class="breadcrumb__area fix" data-background="<?php echo e(asset('uploads/'.$global_setting->banner)); ?>">
    <div class="breadcrumb__bg-shape"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb__content">
                    <h3 class="title"><?php echo e($global_page_item->contact_page_title); ?></h3>
                </div>
            </div>
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb-wrap">
                    <nav class="breadcrumb">
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem"><?php echo e($global_page_item->contact_page_title); ?></span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->

<!--==============================
Contact Area
==============================-->
<section class="contact-page-area overflow-hidden pt-120 pb-120">
    <div class="container">
        <div class="contact-wrap2 pt-120 pb-120 smoke5-bg text-center">
            <div class="row justify-content-end">
                <div class="col-xl-12">
                    <div class="contact-form-wrap2">
                        <div class="section__title mb-30">
                            <span class="sub-title"><?php echo e($global_page_item->contact_form_subheading); ?></span>
                            <h2 class="title"><?php echo e($global_page_item->contact_form_heading); ?></h2>
                        </div>
                        <form action="<?php echo e(route('contact_send_email')); ?>" method="POST" class="contact__form ajax-contact">
                            <?php echo csrf_field(); ?>
                            <div class="row gy-4">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <input type="text" class="form-control style-white" name="name" placeholder="<?php echo e(__('Full Name')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <input type="text" class="form-control style-white" name="email" placeholder="<?php echo e(__('Email Address')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <input type="text" class="form-control style-white" name="phone" placeholder="<?php echo e(__('Phone Number')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <textarea name="message" placeholder="<?php echo e(__('Message')); ?>" class="form-control style-white"></textarea>
                                    </div>
                                </div>
                                <?php if($global_setting->captcha_status == 'Show'): ?>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <div class="mb-2 tal">
                                            <?php echo captcha_img(); ?>

                                        </div>
                                        <input type="text" class="form-control style-white" name="captcha" placeholder="<?php echo e(__('Enter Captcha')); ?>">
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <button type="submit" class="btn mt-30">
                                <span class="btn-text" data-text="<?php echo e($global_page_item->contact_form_button_text); ?>"></span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--======== / Contact Section ========-->

<!-- contact-map -->
<?php if($global_page_item->contact_map_status == 'Show'): ?>
<div class="contact-map-area pt-120 pb-120">
    <?php echo $global_page_item->contact_map_code; ?>

    <div class="container">
        <div class="contact-info-wrap">
            <div class="contact-info-thumb">
                <img src="<?php echo e(asset('uploads/'.$global_page_item->contact_map_photo)); ?>" alt="img">
            </div>
            <ul class="list-wrap">
                <li>
                    <div class="contact-info-card">
                        <div class="contact-info-icon">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <div class="media-body">
                            <p><?php echo e($global_page_item->contact_map_phone_title); ?></p>
                            <h4><?php echo e($global_page_item->contact_map_phone); ?></h4>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="contact-info-card">
                        <div class="contact-info-icon">
                            <i class="fas fa-envelope-open-text"></i>
                        </div>
                        <div class="media-body">
                            <p><?php echo e($global_page_item->contact_map_email_title); ?></p>
                            <h4><?php echo e($global_page_item->contact_map_email); ?></h4>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="contact-info-card">
                        <div class="contact-info-icon">
                            <i class="fas fa-map-marked-alt"></i>
                        </div>
                        <div class="media-body">
                            <p><?php echo e($global_page_item->contact_map_address_title); ?></p>
                            <h4><?php echo e($global_page_item->contact_map_address); ?></h4>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- contact-map-end -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('front.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/contact.blade.php ENDPATH**/ ?>