<?php $__env->startSection('main_content'); ?>
<!--==============================
Breadcrumb Area
==============================-->
<section class="breadcrumb__area fix" data-background="<?php echo e(asset('uploads/'.$global_setting->banner)); ?>">
    <div class="breadcrumb__bg-shape"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb__content">
                    <h3 class="title"><?php echo e($project->title); ?></h3>
                </div>
            </div>
            <div class="col-xl-12 d-flex justify-content-center">
                <div class="breadcrumb-wrap">
                    <nav class="breadcrumb">
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem">
                            <a href="<?php echo e(route('projects')); ?>"><?php echo e($global_page_item->projects_page_title); ?></a>
                        </span>
                        <span class="breadcrumb-separator">/</span>
                        <span property="itemListElement" typeof="ListItem"><?php echo e($project->title); ?></span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->

<!--==============================
    Project Details Area
==============================-->
<section class="project__details-area pt-120 pb-120">
    <div class="container">
        <div class="row gy-60">
            <div class="col-lg-8">
                <div class="project__details-wrap">
                    <div class="project__details-thumb">
                        <div class="thumb">
                            <img src="<?php echo e(asset('uploads/'.$project->photo)); ?>" alt="img">
                        </div>
                    </div>

                    <div class="project__details-content">
                        <h3 class="title mb-15 mt-40">
                            <?php echo e($project->title); ?>

                        </h3>
                        <p class="mb-20">
                            <?php echo $project->description; ?>

                        </p>

                        <?php if($project->quote_person): ?>
                        <blockquote>
                            <div class="quote-icon"><i class="fas fa-quote-right"></i></div>
                            <div class="media-body">
                                <p>
                                    <?php echo nl2br($project->quote_text); ?>

                                </p>
                                <h4 class="blockquote-card_title"><?php echo e($project->quote_person); ?></h4>
                            </div>
                        </blockquote>
                        <?php endif; ?>

                    </div>

                </div>
            </div>
            <div class="col-lg-4">
                <aside class="blog-sidebar">
                    <div class="blog-widget service-widget widget_info">
                        <h4 class="widget-title"><?php echo e(__('Project Information')); ?></h4>
                        <div class="project-info-list">
                            <ul class="list-wrap">
                                <li>
                                    <div class="project-info-icon">
                                        <i class="fas fa-calendar-alt"></i>
                                    </div>
                                    <div class="media-body">
                                        <p><?php echo e(__('Date:')); ?></p>
                                        <strong><?php echo e($project->project_date); ?></strong>
                                    </div>
                                </li>
                                <li>
                                    <div class="project-info-icon">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <div class="media-body">
                                        <p><?php echo e(__('Clients:')); ?></p>
                                        <strong><?php echo e($project->client); ?></strong>
                                    </div>
                                </li>
                                <?php if($project->location): ?>
                                <li>
                                    <div class="project-info-icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div class="media-body">
                                        <p><?php echo e(__('Location:')); ?></p>
                                        <strong><?php echo e($project->location); ?></strong>
                                    </div>
                                </li>
                                <?php endif; ?>
                                <?php if($project->website): ?>
                                <li>
                                    <div class="project-info-icon">
                                        <i class="fas fa-globe"></i>
                                    </div>
                                    <div class="media-body">
                                        <p><?php echo e(__('Website:')); ?></p>
                                        <strong>
                                            <a href="<?php echo e($project->website); ?>" target="_blank"
                                               class="website">
                                                <?php echo e($project->website); ?>

                                            </a>
                                        </strong>
                                    </div>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <?php if($project->phone): ?>
                    <div class="blog-widget sidebar-banner">
                        <h4 class="widget-title">
                            <?php echo nl2br($global_page_item->project_widget_title); ?>

                        </h4>
                        <p class="banner-text">
                            <?php echo nl2br($global_page_item->project_widget_text); ?>

                        </p>
                        <a class="banner-link" href="tel:<?php echo e($project->phone); ?>"><i class="fas fa-phone"></i> <?php echo e($project->phone); ?></a>
                        <a href="<?php echo e(route('appointment')); ?>" class="btn btn-two w-100"><span class="btn-text" data-text="<?php echo e($global_page_item->project_widget_button_text); ?>"></span> <i class="fas fa-arrow-right"></i></a>
                        </form>
                    </div>
                    <?php endif; ?>
                </aside>
            </div>
        </div>
    </div>
</section>
<!-- blog-details-area-end -->

<!--==============================
Cta Area
==============================-->
<?php if($global_page_item->project_cta_status == 'Show'): ?>
<section class="cta-area-1 overflow-hidden pb-120">
    <div class="container">
        <div class="cta-wrap1 pt-120 pb-120 bg-cover" data-background="<?php echo e(asset('uploads/bg/cta-bg1-1.png')); ?>">
            <div class="cta-bg-shape1-1" data-background="<?php echo e(asset('uploads/bg/cta-bg-shape1-1.png')); ?>"></div>
            <div class="row justify-content-center align-items-center">
                <div class="col-xl-7 col-lg-8">
                    <div class="section__title text-center">
                        <span class="sub-title text-white text-anim">
                            <?php echo e($global_page_item->project_cta_subheading); ?>

                        </span>
                        <h2 class="title text-white text-anim2">
                            <?php echo nl2br($global_page_item->project_cta_heading); ?>

                        </h2>
                        <div class="tg-button-wrap mt-40 justify-content-center">
                            <a href="<?php echo e(route('contact')); ?>" class="btn btn-seven">
                                <span class="btn-text" data-text="<?php echo e($global_page_item->project_cta_button_text); ?>"></span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<!--======== / Cta Section ========-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/project.blade.php ENDPATH**/ ?>