@extends('admin.layouts.master')

@section('main_content')
@include('admin.layouts.nav')
@include('admin.layouts.sidebar')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>{{ __('Edit Profile') }}</h1>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="{{ route('admin_profile_submit') }}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-3">
                                        @if(Auth::guard('admin')->user()->photo == null)
                                        <img src="{{ asset('uploads/default.png') }}" alt="" class="profile-photo w_100_p">
                                        @else
                                        <img src="{{ asset('uploads/'.Auth::guard('admin')->user()->photo) }}" alt="" class="profile-photo w_100_p">
                                        @endif
                                        <input type="file" class="mt_10" name="photo">
                                    </div>
                                    <div class="col-md-9">
                                        <div class="mb-4">
                                            <label class="form-label">{{ __('Name') }} *</label>
                                            <input type="text" class="form-control" name="name" value="{{ Auth::guard('admin')->user()->name }}">
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">{{ __('Email') }} *</label>
                                            <input type="text" class="form-control" name="email" value="{{ Auth::guard('admin')->user()->email }}">
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">{{ __('Biography') }}</label>
                                            <textarea name="biography" class="form-control h_150">{{ Auth::guard('admin')->user()->biography }}</textarea>
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">{{ __('Password') }}</label>
                                            <input type="password" class="form-control" name="password">
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">{{ __('Retype Password') }}</label>
                                            <input type="password" class="form-control" name="confirm_password">
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label"></label>
                                            <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection