# Lawyers Portal — Laravel Application

This is the main Laravel application folder for the Lawyers Portal CMS. It contains all the application code, configuration, and asset files.

## 📁 Folder Structure

```
.
├── app/                          # Application code
│   ├── Http/
│   │   ├── Controllers/
│   │   │   ├── Admin/           # Admin panel controllers
│   │   │   │   ├── AdminController.php
│   │   │   │   ├── AdminLawyerController.php
│   │   │   │   ├── AdminServiceController.php
│   │   │   │   ├── AdminPackageController.php
│   │   │   │   ├── AdminPostController.php
│   │   │   │   ├── AdminPhotoController.php
│   │   │   │   ├── AdminVideoController.php
│   │   │   │   ├── AdminFaqController.php
│   │   │   │   ├── AdminTestimonialController.php
│   │   │   │   ├── AdminProjectController.php
│   │   │   │   ├── AdminFeatureController.php
│   │   │   │   ├── AdminSliderController.php
│   │   │   │   ├── AdminSubscriberController.php
│   │   │   │   └── ... (more)
│   │   │   ├── Front/           # Frontend controllers
│   │   │   │   ├── FrontController.php
│   │   │   │   └── FrontAndBackEndBladeExtractController.php
│   │   │   └── Controller.php    # Base controller
│   │   └── Middleware/          # HTTP middleware
│   ├── Models/                  # Eloquent models
│   │   ├── Admin.php
│   │   ├── Lawyer.php
│   │   ├── Service.php
│   │   ├── Feature.php
│   │   ├── Project.php
│   │   ├── Package.php
│   │   ├── PackageFeature.php
│   │   ├── Post.php
│   │   ├── PostCategory.php
│   │   ├── Comment.php
│   │   ├── Reply.php
│   │   ├── Photo.php
│   │   ├── Video.php
│   │   ├── Slider.php
│   │   ├── Faq.php
│   │   ├── Testimonial.php
│   │   ├── Subscriber.php
│   │   ├── Menu.php
│   │   ├── Setting.php
│   │   ├── PageItem.php
│   │   ├── CounterItem.php
│   │   ├── User.php
│   │   └── ... (other models)
│   ├── Mail/
│   │   └── Websitemail.php      # Email notifications
│   └── Providers/
│       └── AppServiceProvider.php
├── bootstrap/                    # Bootstrap files
│   ├── app.php
│   ├── providers.php
│   └── cache/
├── config/                       # Configuration files
│   ├── app.php                  # App configuration
│   ├── auth.php                 # Authentication
│   ├── cache.php                # Caching
│   ├── captcha.php              # Captcha settings
│   ├── database.php             # Database config
│   ├── filesystems.php          # File storage
│   ├── logging.php              # Logging
│   ├── mail.php                 # Email config
│   ├── queue.php                # Queue config
│   ├── services.php             # Service config
│   ├── session.php              # Session config
│   └── ... (other configs)
├── database/
│   ├── migrations/              # Database schema migrations
│   ├── seeders/                 # Database seeders
│   └── factories/               # Model factories for testing
├── public/                       # Web root (DocumentRoot)
│   ├── index.php                # Entry point
│   ├── robots.txt
│   ├── uploads/                 # User uploaded files
│   ├── dist-admin/              # Compiled admin assets
│   ├── dist-front/              # Compiled frontend assets
│   └── css/, js/                # Static assets
├── resources/
│   ├── views/                   # Blade template files
│   ├── css/                     # Tailwind CSS source
│   ├── js/                      # JavaScript source
│   ├── lang/                    # Language files (i18n)
│   └── ... 
├── routes/
│   ├── web.php                  # Web route definitions
│   └── console.php              # Artisan command definitions
├── storage/
│   ├── app/                     # Application file storage
│   ├── framework/               # Framework generated files
│   ├── logs/                    # Application logs
│   └── cache/                   # Cache files
├── tests/
│   ├── TestCase.php             # Base test class
│   ├── Feature/                 # Feature tests
│   └── Unit/                    # Unit tests
├── vendor/                       # Composer dependencies (auto-generated)
├── .env                         # Environment configuration (local)
├── .env.example                 # Environment template
├── .gitignore
├── artisan                      # Laravel CLI tool
├── composer.json                # PHP dependencies
├── composer.lock                # Composer lock file
├── package.json                 # JavaScript dependencies
├── package-lock.json            # npm lock file
├── phpunit.xml                  # PHPUnit configuration
├── vite.config.js               # Vite build configuration
└── README.md
```

## 🚀 Quick Start

### Setup
```bash
# Install dependencies
composer install
npm install

# Configure environment
cp .env.example .env

# Generate key
php artisan key:generate

# Setup database
php artisan migrate
php artisan db:seed --class=AdminSeeder

# Build assets
npm run dev
```

### Running
```bash
php artisan serve
# Visit: http://localhost:8000
```

## 📚 Key Files to Know

### Configuration
- **config/app.php** — Application settings
- **config/database.php** — Database connections
- **config/mail.php** — Email settings
- **config/auth.php** — Authentication configuration

### Application Logic
- **app/Http/Controllers/Admin/** — Admin functionality
- **app/Http/Controllers/Front/** — Public website functionality
- **app/Models/** — Database models (Eloquent ORM)
- **routes/web.php** — Route definitions

### Frontend
- **resources/views/** — Blade templates
- **resources/css/** — Tailwind CSS
- **resources/js/** — JavaScript code
- **vite.config.js** — Asset bundling configuration

### Database
- **database/migrations/** — Schema changes
- **database/seeders/** — Initial data

## 🛣️ Routes Overview

### Frontend Routes (`/`)
- `/` — Home
- `/about`, `/services`, `/projects`, `/lawyers` — Main pages
- `/pricing` — Pricing
- `/blog`, `/post/{slug}` — Blog
- `/contact`, `/appointment` — Forms

### Admin Routes (`/admin`)
- Dashboard, Lawyers, Services, Projects, Packages
- Blog management, Photos, Videos
- FAQs, Testimonials, Settings

See `routes/web.php` for complete route list.

## ⚙️ Models & Relationships

### Core Models
- **Lawyer** — Lawyer profiles
- **Service** — Legal services
- **Feature** — Service features
- **Project** — Portfolio projects

### Content Models
- **Post** — Blog posts
- **Comment** → **Reply** — Discussion
- **Photo**, **Video** — Media

### Business Models
- **Package** → **PackageFeature** — Pricing tiers
- **Testimonial**, **Faq** — Content
- **Slider**, **PageItem** — Homepage

## 📦 Dependencies

### PHP (Composer)
- laravel/framework (^12.0) — Core framework
- laravel/tinker (^2.10) — REPL
- mews/captcha (^3.4) — Captcha
- phpunit/phpunit (^11.5) — Testing

### JavaScript (npm)
- tailwindcss (^4.0) — CSS framework
- vite (^6.2) — Build tool
- laravel-vite-plugin (^1.2) — Integration
- axios (^1.8) — HTTP client

## 🔐 Important Notes

1. **Security**
   - Change default admin password immediately
   - Keep `.env` secure (don't commit to repo)
   - Set `APP_DEBUG=false` in production

2. **File Permissions**
   ```bash
   chmod -R 775 storage bootstrap/cache
   ```

3. **Database**
   - Configured in `.env`
   - Migrations in `database/migrations/`
   - See `../database/lawyers.sql` for full schema

## 🧪 Testing

```bash
php artisan test
./vendor/bin/phpunit
```

## 📖 Documentation

- [Laravel Documentation](https://laravel.com/docs)
- [Blade Templates](https://laravel.com/docs/blade)
- [Eloquent ORM](https://laravel.com/docs/eloquent)
- Main project README: `../README.md`

---

**Last Updated:** February 8, 2026  
**Framework:** Laravel 12.x  
**PHP:** 8.2+
